% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_chains.R
\name{combine_chains}
\alias{combine_chains}
\title{Combine the chain and iteration columns of tidy data frames of draws}
\usage{
combine_chains(data, chain = .chain, iteration = .iteration, into = ".draw")
}
\arguments{
\item{data}{Tidy data frame of draws with columns representing the chain and iteration of each draw.}

\item{chain}{Bare name of column in \code{data} indicating the chain of each row. The default (\code{.chain}) is
the same as used by other functions in \code{tidybayes}.}

\item{iteration}{Bare name of column in \code{data} indicating the iteration of each row. The default
(\code{.iteration}) is the same as used by other functions in \code{tidybayes}.}

\item{into}{Name (as a character vector) of the column to combine chains into. The default, \code{NULL}, replaces the
\code{chain} column with \code{NA}s and writes the combined chain iteration numbers into \code{iteration}. If
provided, \code{chain} and \code{iteration} will not be modified, and the combined iteration number will be written
into a new column named \code{into}.}
}
\value{
A data frame of tidy draws with a combined iteration column
}
\description{
Combines the chain and iteration columns of a tidy data frame of draws from a Bayesian model fit into a new column
that can uniquely identify each draw. Generally speaking \strong{not needed for pure tidybayes code}, as tidybayes
functions now automatically include a \code{.draw} column, but can be useful when interacting with packages that
do not provide such a column.
}
\examples{

library(magrittr)
library(coda)

data(line, package = "coda")

# The `line` posterior has two chains with 200 iterations each:
line \%>\%
  tidy_draws() \%>\%
  summary()

# combine_chains combines the chain and iteration column into the .draw column.
line \%>\%
  tidy_draws() \%>\%
  combine_chains() \%>\%
  summary()

}
\seealso{
\code{\link[emmeans:emmeans]{emmeans::emmeans()}}
}
\author{
Matthew Kay
}
\keyword{manip}
