% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa_generics.R, R/mod_nhpp.R, R/pkg-stats.R
\name{exceedances}
\alias{exceedances}
\alias{exceedances.default}
\alias{exceedances.nhpp}
\alias{exceedances.ts}
\alias{exceedances.double}
\title{Compute exceedances of a threshold for a time series}
\usage{
exceedances(x, ...)

\method{exceedances}{default}(x, ...)

\method{exceedances}{nhpp}(x, ...)

\method{exceedances}{ts}(x, ...)

\method{exceedances}{double}(x, threshold = mean(x, na.rm = TRUE), ...)
}
\arguments{
\item{x}{a numeric vector coercible into a \link[stats:ts]{stats::ts} object}

\item{...}{arguments passed to methods}

\item{threshold}{A value above which to exceed. Default is the \code{\link[=mean]{mean()}}}
}
\value{
An ordered \code{integer} vector giving the indices of the values of \code{x}
that exceed the \code{threshold}.
}
\description{
Compute exceedances of a threshold for a time series
}
\examples{
# Retrieve exceedances of the series mean
fit_nhpp(DataCPSim, tau = 826) |> 
  exceedances()

# Retrieve exceedances of a supplied threshold
fit_nhpp(DataCPSim, tau = 826, threshold = 200) |> 
  exceedances()
}
