% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bar_chart_grouped.R
\name{bar_chart_grouped}
\alias{bar_chart_grouped}
\title{Generates grouped horizontal barchart with scenario triangles.}
\usage{
bar_chart_grouped(
  data,
  cat,
  foreground,
  background,
  markers = NULL,
  series_labels,
  styles = NULL
)
}
\arguments{
\item{data}{data frame in wide format containing data to be plotted}

\item{cat}{vector cointaining category names of values}

\item{foreground}{vector or name of column in data representing heights of bars visible in the foreground}

\item{background}{vector or name of column in data representing heights of bars visible in the background}

\item{markers}{optional vector representing position of triangles}

\item{series_labels}{vector of series titles. Consists of 2 or 3 elements}

\item{styles}{optional dataframe of styles. First column contains styles for foreground series, second for background, third for triangles. dim(styles) must be length(x), length(titles)}
}
\value{
SVG string containing chart
}
\description{
Generates grouped horizontal barchart with scenario triangles.
}
\examples{

#preparing data frames
data <- data.frame(
city = c("Berlin", "Paris", "London", "Munich", "Vienna"),
AC = c(592, 1166, 618, 795, 538),
PL = c(570, 950, 800, 780, 460),
triangles = c(545, 800, 900, 600, 538) #AC toten bardziej na wierzchu
)

#preparing the styles data frame
df_styles <- data.frame(
 AC = c("actual","actual","actual","actual","actual"),
 PL = c("plan","plan","plan","plan","plan"),
 triangles = c("previous", "previous","previous","previous","previous"))

#creating the svg string
barchart_grouped <- bar_chart_grouped(data,
 data$city,  "AC", "PL","triangles", c("triangles", "AC", "PL"), df_styles)

#showing the plot
barchart_grouped \%>\% SVGrenderer()

}
