% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/line_chart_markers.R
\name{line_chart_markers}
\alias{line_chart_markers}
\title{Generates line plot with markers on every value.}
\usage{
line_chart_markers(
  data,
  x,
  series,
  series_labels,
  interval = "months",
  styles = NULL
)
}
\arguments{
\item{data}{data frame containing data to be plotted}

\item{x}{vector cointaining time interwals of the values}

\item{series}{vector containing names of columns in data with values to plot}

\item{series_labels}{vector containing names of series to be shown on the plot}

\item{interval}{intervals on x axis. The width of the bars depends on this parameter}

\item{styles}{optional data frame with style names. Styles of the markers will be plotted accordingly.}
}
\value{
SVG string containing chart
}
\description{
Generates line plot with markers on every value.
}
\examples{

#preparing a data frame
data <- data.frame(
time = c("Jan", "Feb", "Mar", "Apr", "May", "Jun"),
PL = (c(51, 42, 50, 58, 78, 79) - 30),
AC = (c(62, 70, 67, 77, 63, 62) - 30)
)
#preparing the styles data frame
styles <- data.frame(
 PL = c("plan", "plan", "plan", "plan", "plan", "plan"),
 AC = c("actual", "actual", "actual", "forecast", "forecast", "forecast")
)

#generating svg string
line_chart <- line_chart_markers(data, data$time, c("PL", "AC"), c("PL", "AC"),"months", styles)

#show the plot
line_chart \%>\% SVGrenderer()


}
