% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hier_clust_stats.R
\name{details_hier_clust_stats}
\alias{details_hier_clust_stats}
\title{Hierarchical (Agglomerative) Clustering via stats}
\description{
\code{\link[=hier_clust]{hier_clust()}} creates Hierarchical (Agglomerative) Clustering model.
}
\details{
For this engine, there is a single mode: partition
\subsection{Tuning Parameters}{

This model has 1 tuning parameters:
\itemize{
\item \code{num_clusters}: # Clusters (type: integer, default: no default)
}
}

\subsection{Translation from tidyclust to the original package (partition)}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{hier_clust(num_clusters = integer(1)) \%>\% 
  set_engine("stats") \%>\% 
  set_mode("partition") \%>\% 
  translate_tidyclust()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Hierarchical Clustering Specification (partition)
## 
## Main Arguments:
##   num_clusters = integer(1)
##   linkage_method = complete
## 
## Computational engine: stats 
## 
## Model fit template:
## tidyclust::.hier_clust_fit_stats(data = missing_arg(), num_clusters = integer(1), 
##     linkage_method = "complete")
}\if{html}{\out{</div>}}
}

\subsection{Preprocessing requirements}{

Factor/categorical predictors need to be converted to numeric values
(e.g., dummy or indicator variables) for this engine. When using the
formula method via \code{\link[=fit.cluster_spec]{fit()}}, tidyclust
will convert factor columns to indicators.
}

\subsection{References}{
\itemize{
\item Becker, R. A., Chambers, J. M. and Wilks, A. R. (1988). The New S
Language. Wadsworth & Brooks/Cole. (S version.)
\item Everitt, B. (1974). Cluster Analysis. London: Heinemann Educ. Books.
\item Hartigan, J.A. (1975). Clustering Algorithms. New York: Wiley.
\item Sneath, P. H. A. and R. R. Sokal (1973). Numerical Taxonomy. San
Francisco: Freeman.
\item Anderberg, M. R. (1973). Cluster Analysis for Applications. Academic
Press: New York.
\item Gordon, A. D. (1999). Classification. Second Edition. London: Chapman
and Hall / CRC
\item Murtagh, F. (1985). “Multidimensional Clustering Algorithms”, in
COMPSTAT Lectures 4. Wuerzburg: Physica-Verlag (for algorithmic
details of algorithms used).
\item McQuitty, L.L. (1966). Similarity Analysis by Reciprocal Pairs for
Discrete and Continuous Data. Educational and Psychological
Measurement, 26, 825–831. \url{doi:10.1177/001316446602600402}.
\item Legendre, P. and L. Legendre (2012). Numerical Ecology, 3rd English
ed. Amsterdam: Elsevier Science BV.
\item Murtagh, Fionn and Legendre, Pierre (2014). Ward’s hierarchical
agglomerative clustering method: which algorithms implement Ward’s
criterion? Journal of Classification, 31, 274–295.
\url{doi:10.1007/s00357-014-9161-z}.
}
}
}
\keyword{internal}
