% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse.R
\name{parse_steps}
\alias{parse_steps}
\title{Parse the steps of the CWL workflow into a data frame}
\usage{
parse_steps(x)
}
\arguments{
\item{x}{CWL object}
}
\value{
List or data frame of steps
}
\description{
Parse the steps of the CWL workflow into a data frame
}
\examples{
# steps represented by a dictionary
system.file("cwl/sbg/workflow/rnaseq-salmon.json", package = "tidycwl") \%>\%
  read_cwl_json() \%>\%
  parse_steps() \%>\%
  nrow()

# steps represented by a list
system.file("cwl/sbg/workflow/rnaseq-salmon.cwl", package = "tidycwl") \%>\%
  read_cwl_yaml() \%>\%
  parse_steps() \%>\%
  length()
}
