% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assign_portfolio.R
\name{assign_portfolio}
\alias{assign_portfolio}
\title{Assign Portfolios Based on Sorting Variable}
\usage{
assign_portfolio(
  data,
  sorting_variable,
  breakpoint_options = NULL,
  breakpoint_function = compute_breakpoints,
  data_options = NULL
)
}
\arguments{
\item{data}{A data frame containing the dataset for portfolio assignment.}

\item{sorting_variable}{A string specifying the column name in \code{data} to be
used for sorting and determining portfolio assignments based on the
breakpoints.}

\item{breakpoint_options}{An optional named list of arguments passed to
\code{breakpoint_function}.}

\item{breakpoint_function}{A function to compute breakpoints. The default is
set to \link{compute_breakpoints}.}

\item{data_options}{A named list of \link{data_options} with characters,
indicating the column names required to run this function. The required
column names identify dates.  Defaults to \code{date = date} and \code{id = permno}.}
}
\value{
A vector of portfolio assignments for each row in the input \code{data}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function assigns data points to portfolios based on a specified
sorting variable and the selected function to compute breakpoints. Users
can specify a function to compute breakpoints. The function must take
\code{data} and \code{sorting_variable} as the first two arguments. Additional
arguments are passed with a named list \link{breakpoint_options}. The
function needs to return an ascending vector of breakpoints. By default,
breakpoints are computed with \link{compute_breakpoints}. The default
column names can be modified using \link{data_options}.
}
\examples{
data <- data.frame(
  id = 1:100,
  exchange = sample(c("NYSE", "NASDAQ"), 100, replace = TRUE),
  market_cap = 1:100
)

assign_portfolio(data, "market_cap", breakpoint_options(n_portfolios = 5))

assign_portfolio(
  data, "market_cap",
  breakpoint_options(percentiles = c(0.2, 0.4, 0.6, 0.8), breakpoint_exchanges = c("NYSE"))
)

}
