% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relocate_dt.R
\name{relocate_dt}
\alias{relocate_dt}
\title{Change column order}
\usage{
relocate_dt(.data, ..., how = "first", where = NULL)
}
\arguments{
\item{.data}{A data.frame}

\item{...}{Columns to move}

\item{how}{The mode of movement, including "first","last","after","before".
Default uses "first".}

\item{where}{Destination of columns selected by \code{...}.
Applicable for "after" and "before" mode.}
}
\value{
A data.table with rearranged columns.
}
\description{
Change the position of columns,
 using the same syntax as `select_dt()`. Check similar function
 as `relocate` in \pkg{dplyr}.
}
\examples{
df <- data.table(a = 1, b = 1, c = 1, d = "a", e = "a", f = "a")
df
df \%>\% relocate_dt(f)
df \%>\% relocate_dt(a,how = "last")

df \%>\% relocate_dt(is.character)
df \%>\% relocate_dt(is.numeric, how = "last")
df \%>\% relocate_dt("[aeiou]")

df \%>\% relocate_dt(a, how = "after",where = f)
df \%>\% relocate_dt(f, how = "before",where = a)
df \%>\% relocate_dt(f, how = "before",where = c)
df \%>\% relocate_dt(f, how = "after",where = c)

df2 <- data.table(a = 1, b = "a", c = 1, d = "a")
df2 \%>\% relocate_dt(is.numeric,
                    how = "after",
                    where = is.character)
df2 \%>\% relocate_dt(is.numeric,
                    how="before",
                    where = is.character)
}
\seealso{
\code{\link[dplyr]{relocate}}
}
