% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count.R
\name{count}
\alias{count}
\alias{add_count}
\title{Count observations by group}
\usage{
count(.data, ..., sort = FALSE, name = "n")

add_count(.data, ..., name = "n")
}
\arguments{
\item{.data}{data.table}

\item{...}{variables to group by.}

\item{sort}{logical. If TRUE result will be sorted in desending order by resulting variable.}

\item{name}{character. Name of resulting variable. Default uses "n".}
}
\value{
data.table
}
\description{
Analogous function for \code{count} and \code{add_count} in \pkg{dplyr}.
}
\examples{
a = as.data.table(mtcars)
count(a,cyl)
count(a,cyl,sort = TRUE)
a

b = as.data.table(iris)
b \%>\% add_count(Species,name = "N")
b
}
