% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyhydat-package.R
\docType{package}
\name{tidyhydat-package}
\alias{tidyhydat}
\alias{tidyhydat-package}
\title{tidyhydat: Extract and Tidy Canadian 'Hydrometric' Data}
\description{
Provides functions to access historical and real-time national 'hydrometric'
    data from Water Survey of Canada data sources (<https://dd.weather.gc.ca/hydrometric/csv/> and
    <https://collaboration.cmc.ec.gc.ca/cmc/hydrometrics/www/>) and then applies tidy data principles.
}
\references{
To download the latest version of hydat please:
 \itemize{
  \item use the \code{download_hydat()} function.
  \item If that fails you can download directly from this link:
  \url{https://collaboration.cmc.ec.gc.ca/cmc/hydrometrics/www/}
  }

For more information on tidy data please see
\itemize{
 \item Wickham, Hadley. 2014. Tidy Data. The Journal of Statistical Software. 59. \url{https://www.jstatsoft.org/article/view/v059i10}
 \item tidy data vignette: \url{https://CRAN.R-project.org/package=tidyr/vignettes/tidy-data.html}
 }

 For more information on HYDAT and ECCC data sources 
 \itemize{
   \item Please see this description of the database: 
   \url{https://www.canada.ca/en/environment-climate-change/services/water-overview/quantity/monitoring/survey/data-products-services/national-archive-hydat.html}
   \item This page is landing page for technical description of HYDAT:
   \url{https://collaboration.cmc.ec.gc.ca/cmc/hydrometrics/www/}
   \item This page links to a document that outlines database table definitions:
   \url{https://collaboration.cmc.ec.gc.ca/cmc/hydrometrics/www/HYDAT_Definition_EN.pdf}
   \item This FAQ provides a helpful list of ECCC data source questions:
   \url{https://wateroffice.ec.gc.ca/contactus/faq_e.html}
   }
}
\seealso{
Useful links:
\itemize{
  \item \url{https://docs.ropensci.org/tidyhydat/}
  \item Report bugs at \url{https://github.com/ropensci/tidyhydat/issues}
}

}
\author{
\strong{Maintainer}: Sam Albers \email{sam.albers@gov.bc.ca} (\href{https://orcid.org/0000-0002-9270-7884}{ORCID})

Other contributors:
\itemize{
  \item David Hutchinson \email{david.hutchinson@canada.ca} [contributor]
  \item Dewey Dunnington \email{dewey@fishandwhistle.net} [contributor]
  \item Ryan Whaley \email{rdgwhaley@gmail.com} [contributor]
  \item Province of British Columbia [copyright holder]
  \item Luke Winslow (Reviewed for rOpenSci) [reviewer]
  \item Laura DeCicco (Reviewed for rOpenSci) [reviewer]
}

}
\keyword{internal}
