% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{format_eta}
\alias{format_eta}
\title{Format \code{eta} For Input into \code{fit_lda_c}}
\usage{
format_eta(eta, k, Nv)
}
\arguments{
\item{eta}{the prior for words over topics. Can be a numeric scalar, numeric
vector, or numeric matrix.}

\item{k}{the number of topics.}

\item{Nv}{the total size of the vocabulary as inherited from \code{ncol(dtm)}
in \code{\link[tidylda]{tidylda}}.}
}
\value{
Returns a list with two elements: \code{eta} and \code{eta_class}.
  \code{eta} is the post-formatted version of \code{eta} in the form of a
  \code{k} by \code{Nv} numeric matrix. \code{eta_class} is a character
  denoting whether or not the user-supplied \code{eta} was a "scalar",
  "vector", or "matrix".
}
\description{
There are a bunch of ways users could format \code{eta} but the C++ Gibbs
  sampler in \code{\link[tidylda]{fit_lda_c}} only takes it one way. This function does the
  appropriate formatting. It also returns errors if the user input a malformatted
  \code{eta}.
}
\keyword{internal}
