% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyllm.R
\name{last_reply}
\alias{last_reply}
\title{Retrieve Last Reply from an Assistant}
\usage{
last_reply(.llm = NULL, .json = FALSE)
}
\arguments{
\item{.llm}{An LLMMessage object containing the history of messages exchanged.
This must be a valid LLMMessage object; otherwise, the function will stop with an error.}

\item{.json}{Should structured json data from the last reply be returned as R list (default: FALSE)}
}
\value{
Returns the content of the last reply made by the assistant. If the assistant
has not replied yet, or if there are no assistant messages in the history, \code{NULL} is returned.
}
\description{
This function extracts the last reply made by the assistant from a given LLMMessage object.
It is particularly useful for fetching the most recent response from the assistant to display
or log it separately.
}
\note{
This function only returns the content of the last assistant message and does not include
media or other types of content that might be attached to the message.
}
\seealso{
\code{\link{LLMMessage}} for details on the message object structure.
}
