% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_claude.R
\name{send_claude_batch}
\alias{send_claude_batch}
\title{Send a Batch of Messages to Claude API}
\usage{
send_claude_batch(
  .llms,
  .model = "claude-3-5-sonnet-20241022",
  .max_tokens = 1024,
  .temperature = NULL,
  .top_k = NULL,
  .top_p = NULL,
  .stop_sequences = NULL,
  .api_url = "https://api.anthropic.com/",
  .verbose = FALSE,
  .dry_run = FALSE,
  .overwrite = FALSE,
  .max_tries = 3,
  .timeout = 60,
  .id_prefix = "tidyllm_claude_req_"
)
}
\arguments{
\item{.llms}{A list of LLMMessage objects containing conversation histories.}

\item{.model}{Character string specifying the Claude model version (default: "claude-3-5-sonnet-20241022").}

\item{.max_tokens}{Integer specifying the maximum tokens per response (default: 1024).}

\item{.temperature}{Numeric between 0 and 1 controlling response randomness.}

\item{.top_k}{Integer for diversity by limiting the top K tokens.}

\item{.top_p}{Numeric between 0 and 1 for nucleus sampling.}

\item{.stop_sequences}{Character vector of sequences that halt response generation.}

\item{.api_url}{Base URL for the Claude API (default: "https://api.anthropic.com/").}

\item{.verbose}{Logical; if TRUE, prints a message with the batch ID (default: FALSE).}

\item{.dry_run}{Logical; if TRUE, returns the prepared request object without executing it (default: FALSE).}

\item{.overwrite}{Logical; if TRUE, allows overwriting an existing batch ID associated with the request (default: FALSE).}

\item{.max_tries}{Maximum number of retries to perform the request.}

\item{.timeout}{Integer specifying the request timeout in seconds (default: 60).}

\item{.id_prefix}{Character string to specify a prefix for generating custom IDs when names in \code{.llms} are missing.
Defaults to "tidyllm_claude_req_".}
}
\value{
An updated and named list of \code{.llms} with identifiers that align with batch responses, including a \code{batch_id} attribute.
}
\description{
This function creates and submits a batch of messages to the Claude API for asynchronous processing.
}
