% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_claude.R
\name{claude_chat}
\alias{claude_chat}
\title{Interact with Claude AI models via the Anthropic API}
\usage{
claude_chat(
  .llm,
  .model = "claude-3-7-sonnet-20250219",
  .max_tokens = 2048,
  .temperature = NULL,
  .top_k = NULL,
  .top_p = NULL,
  .metadata = NULL,
  .stop_sequences = NULL,
  .tools = NULL,
  .json_schema = NULL,
  .api_url = "https://api.anthropic.com/",
  .verbose = FALSE,
  .max_tries = 3,
  .timeout = 60,
  .stream = FALSE,
  .dry_run = FALSE,
  .thinking = FALSE,
  .thinking_budget = 1024
)
}
\arguments{
\item{.llm}{An LLMMessage object containing the conversation history and system prompt.}

\item{.model}{Character string specifying the Claude model version (default: "claude-3-5-sonnet-20241022").}

\item{.max_tokens}{Integer specifying the maximum number of tokens in the response (default: 1024).}

\item{.temperature}{Numeric between 0 and 1 controlling response randomness.}

\item{.top_k}{Integer controlling diversity by limiting the top K tokens.}

\item{.top_p}{Numeric between 0 and 1 for nucleus sampling.}

\item{.metadata}{List of additional metadata to include with the request.}

\item{.stop_sequences}{Character vector of sequences that will halt response generation.}

\item{.tools}{List of additional tools or functions the model can use.}

\item{.json_schema}{A schema to enforce an output structure}

\item{.api_url}{Base URL for the Anthropic API (default: "https://api.anthropic.com/").}

\item{.verbose}{Logical; if TRUE, displays additional information about the API call (default: FALSE).}

\item{.max_tries}{Maximum retries to peform request}

\item{.timeout}{Integer specifying the request timeout in seconds (default: 60).}

\item{.stream}{Logical; if TRUE, streams the response piece by piece (default: FALSE).}

\item{.dry_run}{Logical; if TRUE, returns the prepared request object without executing it (default: FALSE).}

\item{.thinking}{Logical; if TRUE, enables Claude's thinking mode for complex reasoning tasks (default: FALSE).}

\item{.thinking_budget}{Integer specifying the maximum tokens Claude can spend on thinking (default: 1024). Must be at least 1024.}
}
\value{
A new LLMMessage object containing the original messages plus Claude's response.
}
\description{
Interact with Claude AI models via the Anthropic API
}
\examples{
\dontrun{
# Basic usage
msg <- llm_message("What is R programming?")
result <- claude_chat(msg)

# With custom parameters
result2 <- claude_chat(msg, 
                 .temperature = 0.7, 
                 .max_tokens = 1000)
}

}
