% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spread_each.R
\name{spread_each}
\alias{spread_each}
\title{Spread multiple variables}
\usage{
spread_each(data, key, ..., fill = NA, convert = FALSE, drop = FALSE,
  sep = ".", key.first = TRUE)
}
\arguments{
\item{data}{A data frame.}

\item{key}{Column names or positions. This is passed to
\code{\link[tidyselect:vars_pull]{tidyselect::vars_pull()}}.

These arguments are passed by expression and support
\link[rlang:quasiquotation]{quasiquotation} (you can unquote column
names or column positions).}

\item{...}{the columns to act as the values to spread out.}

\item{fill}{If set, missing values will be replaced with this value. Note
that there are two types of missingness in the input: explicit missing
values (i.e. \code{NA}), and implicit missings, rows that simply aren't
present. Both types of missing value will be replaced by \code{fill}.}

\item{convert}{If \code{TRUE}, \code{\link[=type.convert]{type.convert()}} with \code{asis =
  TRUE} will be run on each of the new columns. This is useful if the value
column was a mix of variables that was coerced to a string. If the class of
the value column was factor or date, note that will not be true of the new
columns that are produced, which are coerced to character before type
conversion.}

\item{drop}{If \code{FALSE}, will keep factor levels that don't appear in the
data, filling in missing combinations with \code{fill}.}

\item{sep}{the character to use to separate parts of column names.}

\item{key.first}{If \code{TRUE}, the default, the columns are named
\code{{key level}{sep}{value column name}},
otherwise the format is \code{{value column name}{sep}{key level}{sep}}}

\item{.}{The separator between the key levels and the value column names.}
}
\value{
A wide \code{\link[tibble:tbl_df]{tbl_df}}, with multiple value columns spread out.
}
\description{
This is a multiple variable version of the function
\code{\link[tidyr:spread]{tidyr::spread()}}.
}
\examples{
library(dplyr)
data <- mutate(expand.grid( x = c( 'a', 'b', 'c')
                    , y = c( 'd', 'e', 'f')
                    , .rep = 1:10
                    ), v = rnorm(90))
long <- summarise(group_by(data, x, y),N=n(), sum=sum(v))

spread_each(long, y, N, sum)
}
\seealso{
\itemize{
\item \href{https://en.wikipedia.org/wiki/Wide_and_narrow_data}{Wide versus long data} (also known as narrow data) on Wikipedia.
\item \code{\link[tidyr:spread]{tidyr::spread()}} for the single variable version.
}
}
