% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hyper_filter.R
\name{hyper_filter}
\alias{hyper_filter}
\alias{hyper_filter.tidync}
\title{Subset NetCDF variable by expression}
\usage{
hyper_filter(.x, ...)

\method{hyper_filter}{tidync}(.x, ...)
}
\arguments{
\item{.x}{NetCDF file, connection object, or \code{tidync} object}

\item{...}{currently ignored}
}
\value{
data frame
}
\description{
The \code{\link[=hyper_filter]{hyper_filter()}} acts on a \link{tidync} object by matching one or more
filtering expressions like with \code{dplyr::filter}. This allows us to lazily
specify a subset from a NetCDF array without pulling  any data. The modified
object may be printed to see the effects of subsetting, or saved for further
use.
}
\details{
The function \code{\link[=hyper_filter]{hyper_filter()}} will act on an existing tidync object or a
source string.

Filter arguments must be named as per the dimensions in the variable in form
\code{dimname = dimname < 10}. This is a restrictive variant of \code{\link[dplyr:filter]{dplyr::filter()}},
with a syntax more like \code{\link[dplyr:mutate]{dplyr::mutate()}}. This ensures that each element is
named, so we know which dimension to apply this to, but also that the
expression evaluated against can do some extra work for a nuanced test.

There are special columns provided with each axis, one is 'index' so that
exact matching can be done by position, or to ignore the actual value of the
coordinate. That means we can use a form like \code{dimname = index < 10} to
subset by position in the array index, without necessarily knowing the
values along that dimension.
}
\examples{
f <- "S20080012008031.L3m_MO_CHL_chlor_a_9km.nc"
l3file <- system.file("extdata/oceandata", f, package= "tidync")
## filter by value
tidync(l3file) \%>\% hyper_filter(lon = lon < 100)
## filter by index
tidync(l3file) \%>\% hyper_filter(lon = index < 100)

## filter in combination/s
tidync(l3file) \%>\% hyper_filter(lat = abs(lat) < 10, lon = index < 100)
}
