% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggstrat-plot_addons.R
\name{layer_dendrogram}
\alias{layer_dendrogram}
\alias{plot_layer_dendrogram}
\alias{layer_zone_boundaries}
\title{Add a dendrogram as a layer or facet}
\usage{
layer_dendrogram(
  object,
  mapping,
  ...,
  colour = "black",
  size = 0.5,
  linetype = 1,
  alpha = NA,
  sequential_facets = TRUE
)

plot_layer_dendrogram(object, mapping, ..., panel_label = "CONISS")

layer_zone_boundaries(
  object,
  mapping,
  ...,
  linetype = 2,
  alpha = 0.7,
  colour = "black",
  size = 0.5
)
}
\arguments{
\item{object}{A \link{nested_hclust} object.}

\item{mapping}{Map at least one axis (x or y) to a qualifier, like \code{aes(x = depth)} or similar.}

\item{...}{Use facet_var = "CONISS" or similar to name the panel}

\item{linetype, alpha, colour, size}{Customize the apperance of boundary/dendrogram segment lines}

\item{sequential_facets}{TRUE will result in the panel containing the dendrogram added to the right
of the plot.}

\item{panel_label}{Use to label a pane on a stanalone dendrogram plot}
}
\value{
A \code{\link[ggplot2:layer]{ggplot2::layer()}}
}
\description{
Add a dendrogram as a layer or facet
}
\examples{
library(ggplot2)
library(dplyr, warn.conflicts = FALSE)

alta_coniss <- nested_data(
  alta_lake_geochem,
  qualifiers = c(age, depth, zone),
  key = param,
  value = value,
  trans = scale
) \%>\%
  nested_chclust_coniss()

ggplot() +
  layer_dendrogram(alta_coniss, aes(y = depth)) +
  scale_y_reverse()

}
