% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add-proportional.R
\name{add_areastack_absolute}
\alias{add_areastack_absolute}
\alias{add_areastack_relative}
\title{Add area stack}
\usage{
add_areastack_absolute(
  plot,
  linewidth = 0.25,
  alpha = 0.4,
  reverse = FALSE,
  replace_na = FALSE,
  ...
)

add_areastack_relative(
  plot,
  linewidth = 0.25,
  alpha = 0.4,
  reverse = FALSE,
  replace_na = FALSE,
  ...
)
}
\arguments{
\item{plot}{A \code{tidyplot} generated with the function \code{tidyplot()}.}

\item{linewidth}{Thickness of the line in points (pt). Typical values range between \code{0.25} and \code{1}.}

\item{alpha}{A \code{number} between \code{0} and \code{1} for the opacity of an object. A value of \code{0} is completely transparent, \code{1} is completely opaque.}

\item{reverse}{Whether the order should be reversed or not. Defaults to \code{FALSE}, meaning not reversed.}

\item{replace_na}{Whether to replace \code{count = NA} with \code{count = 0}.}

\item{...}{Arguments passed on to the \code{geom} function.}
}
\value{
A \code{tidyplot} object.
}
\description{
Add area stack
}
\examples{
# for a `count` provide `x` and `color`
# `count` of the data points in each `energy_type` category
energy \%>\%
  tidyplot(x = year, color = energy_type) \%>\%
  add_areastack_absolute()

energy \%>\%
  tidyplot(x = year, color = energy_type) \%>\%
  add_areastack_relative()

# for a `sum` provide `x`, `y` and `color`
# `sum` of `power` in each `energy_type` category
energy \%>\%
  tidyplot(x = year, y = power, color = energy_type) \%>\%
  add_areastack_absolute()

energy \%>\%
  tidyplot(x = year, y = power, color = energy_type) \%>\%
  add_areastack_relative()

# Flip x and y axis
energy \%>\%
  tidyplot(x = power, y = year, color = energy_type) \%>\%
  add_areastack_absolute(orientation = "y")

energy \%>\%
  tidyplot(x = power, y = year, color = energy_type) \%>\%
  add_areastack_relative(orientation = "y")

}
