% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add-points.R
\name{add_data_points}
\alias{add_data_points}
\alias{add_data_points_jitter}
\alias{add_data_points_beeswarm}
\title{Add data points}
\usage{
add_data_points(
  plot,
  data = all_rows(),
  shape = 19,
  size = 1,
  white_border = FALSE,
  dodge_width = NULL,
  preserve = "total",
  rasterize = FALSE,
  rasterize_dpi = 300,
  ...
)

add_data_points_jitter(
  plot,
  data = all_rows(),
  shape = 19,
  size = 1,
  white_border = FALSE,
  dodge_width = NULL,
  jitter_width = 0.2,
  jitter_height = 0,
  preserve = "total",
  rasterize = FALSE,
  rasterize_dpi = 300,
  ...
)

add_data_points_beeswarm(
  plot,
  data = all_rows(),
  shape = 19,
  size = 1,
  white_border = FALSE,
  cex = 3,
  corral = "wrap",
  corral.width = 0.5,
  dodge_width = NULL,
  preserve = "total",
  rasterize = FALSE,
  rasterize_dpi = 300,
  ...
)
}
\arguments{
\item{plot}{A \code{tidyplot} generated with the function \code{tidyplot()}.}

\item{data}{The data to be displayed in this layer. There are three options:
\itemize{
\item If \code{all_rows()} (the default) the complete dataset is displayed.
\item A \code{function} to subset the plot data. See \code{filter_rows()} and friends.
\item A \code{data.frame} to override the plot data.
}}

\item{shape}{An \code{integer} between \code{0} and \code{24}, representing the shape of the
plot symbol.

\figure{unnamed-chunk-1-1.png}}

\item{size}{A \code{number} representing the size of the plot symbol. Typical
values range between \code{1} and \code{3}.}

\item{white_border}{Whether to include a white border around data points. Defaults to \code{FALSE}.}

\item{dodge_width}{For adjusting the distance between grouped objects. Defaults
to \code{0.8} for plots with at least one discrete axis and \code{0} for plots with two
continuous axes.}

\item{preserve}{Should dodging preserve the \code{"total"} width of all elements at
a position, or the width of a \code{"single"} element?}

\item{rasterize}{If \code{FALSE} (the default) the layer will be constructed of
vector shapes. If \code{TRUE} the layer will be rasterized to a pixel image. This can
be useful when plotting many individual objects (1,000 or more) compromises
the performance of the generated PDF file.}

\item{rasterize_dpi}{The resolution in dots per inch (dpi) used for rastering
the layer if \code{rasterize} is \code{TRUE}. The default is \code{300} dpi.}

\item{...}{Arguments passed on to the \code{geom} function.}

\item{jitter_width}{Amount of random noise to be added to the
horizontal position of the of the data points. This can be useful to deal
with overplotting. Typical values range between \code{0} and \code{1}.}

\item{jitter_height}{Amount of random noise to be added to the
vertical position of the of the data points. This can be useful to deal
with overplotting. Typical values range between \code{0} and \code{1}.}

\item{cex}{Scaling for adjusting point spacing (see \code{\link[beeswarm:swarmx]{beeswarm::swarmx()}}).
Values between 1 (default) and 3 tend to work best.}

\item{corral}{\code{string}. Method used to adjust points that would be placed to
wide horizontally, default is \code{"none"}. See details below.}

\item{corral.width}{\code{numeric}. Width of the corral, default is \code{0.9}.}
}
\value{
A \code{tidyplot} object.
}
\description{
Add data points
}
\details{
\itemize{
\item \code{add_data_points_beeswarm()} is based on \code{ggbeeswarm::geom_beeswarm()}.
Check there for additional arguments.
\item \code{add_data_points()} and friends support rasterization. See examples and \href{https://jbengler.github.io/tidyplots/articles/Advanced-plotting.html#rasterization}{Advanced plotting}.
\item \code{add_data_points()} and friends support data subsetting. See examples and \href{https://jbengler.github.io/tidyplots/articles/Advanced-plotting.html#data-subsetting}{Advanced plotting}.
}
}
\examples{
study \%>\%
  tidyplot(x = treatment, y = score, color = treatment) \%>\%
  add_data_points()

study \%>\%
  tidyplot(x = treatment, y = score, color = treatment) \%>\%
  add_data_points_jitter()

study \%>\%
  tidyplot(x = treatment, y = score, color = treatment) \%>\%
  add_data_points_beeswarm()

# Changing arguments
study \%>\%
  tidyplot(x = treatment, y = score, color = treatment) \%>\%
  add_data_points_jitter(jitter_width = 1)

animals \%>\%
  tidyplot(x = weight, y = size) \%>\%
  add_data_points(white_border = TRUE)

animals \%>\%
  tidyplot(x = weight, y = size) \%>\%
  add_data_points(alpha = 0.4)

# Rasterization
animals \%>\%
  tidyplot(x = weight, y = size) \%>\%
  add_data_points(rasterize = TRUE, rasterize_dpi = 50)

# Data subsetting
animals \%>\%
  tidyplot(x = weight, y = size) \%>\%
  add_data_points() \%>\%
  add_data_points(data = filter_rows(size > 300), color = "red")

}
