% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add-stats.R
\name{add_test_pvalue}
\alias{add_test_pvalue}
\alias{add_test_asterisks}
\title{Add statistical test}
\usage{
add_test_pvalue(
  plot,
  padding_top = 0.15,
  method = "t_test",
  p.adjust.method = "none",
  ref.group = NULL,
  label = "{format_p_value(p.adj, 0.0001)}",
  label.size = 7/ggplot2::.pt,
  step.increase = 0.15,
  vjust = -0.25,
  bracket.nudge.y = 0.1,
  hide.ns = FALSE,
  p.adjust.by = "panel",
  symnum.args = list(cutpoints = c(0, 0.001, 0.01, 0.05, Inf), symbols = c("***", "**",
    "*", "ns")),
  hide_info = FALSE,
  ...
)

add_test_asterisks(
  plot,
  padding_top = 0.1,
  method = "t_test",
  p.adjust.method = "none",
  ref.group = NULL,
  label = "p.adj.signif",
  label.size = 10/ggplot2::.pt,
  step.increase = 0.2,
  vjust = 0.3,
  bracket.nudge.y = 0.15,
  hide.ns = TRUE,
  p.adjust.by = "panel",
  symnum.args = list(cutpoints = c(0, 0.001, 0.01, 0.05, Inf), symbols = c("***", "**",
    "*", "ns")),
  hide_info = FALSE,
  ...
)
}
\arguments{
\item{plot}{A \code{tidyplot} generated with the function \code{tidyplot()}.}

\item{padding_top}{Extra padding above the data points to accommodate the statistical comparisons.}

\item{method}{a character string indicating which method to be used for
pairwise comparisons. Default is \code{"t_test"}. Allowed methods
include pairwise comparisons methods implemented in the \code{rstatix} R
package. These methods are: \code{"wilcox_test", "t_test", "sign_test",
 "dunn_test", "emmeans_test", "tukey_hsd", "games_howell_test"}.}

\item{p.adjust.method}{method for adjusting p values (see
\code{\link[stats]{p.adjust}}).  Has impact only in a situation, where
multiple pairwise tests are performed; or when there are multiple grouping
variables. Ignored when the specified method is \code{"tukey_hsd"} or
\code{"games_howell_test"} because they come with internal p adjustment
method. Allowed values include "holm", "hochberg", "hommel", "bonferroni",
"BH", "BY", "fdr", "none". If you don't want to adjust the p value (not
recommended), use p.adjust.method = "none".}

\item{ref.group}{a character string or a numeric value specifying the
 reference group. If specified, for a given grouping variable, each of the
 group levels will be compared to the reference group (i.e. control group).

 \code{ref.group} can be also \code{"all"}. In this case, each of the
 grouping variable levels is compared to all (i.e. basemean).

 Allowed values can be: \itemize{ \item \strong{numeric value}: specifying
 the rank of the reference group. For example, use \code{ref.group = 1} when
 the first group is the reference; use \code{ref.group = 2} when the second
 group is the reference, and so on. This works for all situations, including
 i) when comparisons are performed between x-axis groups and ii) when
 comparisons are performed between legend groups. \item \strong{character
 value}: For example, you can use \code{ref.group = "ctrl"} instead of using
 the numeric rank value of the "ctrl" group. \item \strong{"all"}: In this
 case, each of the grouping variable levels is compared to all (i.e.
 basemean). }}

\item{label}{character string specifying label. Can be: \itemize{ \item the
column containing the label (e.g.: \code{label = "p"} or \code{label =
"p.adj"}), where \code{p} is the p-value. Other possible values are
\code{"p.signif", "p.adj.signif", "p.format", "p.adj.format"}. \item an
expression that can be formatted by the \code{\link[glue]{glue}()} package.
For example, when specifying \code{label = "Wilcoxon, p = \{p\}"}, the
expression \{p\} will be replaced by its value. \item a combination of
plotmath expressions and glue expressions. You may want some of the
statistical parameter in italic; for example:\code{label = "Wilcoxon,
italic(p)= {p}"}}.}

\item{label.size}{change the size of the label text}

\item{step.increase}{numeric vector with the increase in fraction of total
height for every additional comparison to minimize overlap.}

\item{vjust}{move the text up or down relative to the bracket.}

\item{bracket.nudge.y}{Vertical adjustment to nudge brackets by (in fraction
of the total height). Useful to move up or move down the bracket. If
positive value, brackets will be moved up; if negative value, brackets are
moved down.}

\item{hide.ns}{can be logical value (\code{TRUE} or \code{FALSE}) or a character vector (\code{"p.adj"} or \code{"p"}).}

\item{p.adjust.by}{possible value is one of \code{c("group", "panel")}.
Default is \code{"group"}: for a grouped data, if pairwise test is
performed, then the p-values are adjusted for each group level
independently. P-values are adjusted by panel when \code{p.adjust.by =
"panel"}.}

\item{symnum.args}{a list of arguments to pass to the function
 \code{\link[stats]{symnum}} for symbolic number coding of p-values. For
 example, \code{symnum.args <- list(cutpoints = c(0, 0.0001, 0.001, 0.01,
 0.05, Inf), symbols = c("****", "***", "**", "*",  "ns"))}.

 In other words, we use the following convention for symbols indicating
 statistical significance: \itemize{ \item \code{ns}: p > 0.05 \item
 \code{*}: p <= 0.05 \item \code{**}: p <= 0.01 \item \code{***}: p <= 0.001
 \item \code{****}:  p <= 0.0001 }}

\item{hide_info}{Whether to hide details about the statistical testing as caption. Defaults to \code{FALSE}.}

\item{...}{Arguments passed on to \code{ggpubr::geom_pwc()}.}
}
\value{
A \code{tidyplot} object.
}
\description{
Add statistical test
}
\details{
\itemize{
\item \code{add_test_pvalue()} and \code{add_test_asterisks()} use \code{ggpubr::geom_pwc()}.
Check there for additional arguments.
}
}
\examples{
study |>
  tidyplot(x = dose, y = score, color = group) |>
  add_mean_dash() |>
  add_sem_errorbar() |>
  add_data_points() |>
  add_test_pvalue()

# Change stat methods
study |>
  tidyplot(x = dose, y = score, color = group) |>
  add_mean_dash() |>
  add_sem_errorbar() |>
  add_data_points() |>
  add_test_pvalue(method = "wilcoxon", p.adjust.method = "BH")

# Define reference group to test against
study |>
  tidyplot(x = treatment, y = score, color = treatment) |>
  add_mean_dash() |>
  add_sem_errorbar() |>
  add_data_points() |>
  add_test_pvalue(ref.group = "A")

# hide non-significant p values
gene_expression |>
  # filter to one gene
  dplyr::filter(external_gene_name == "Apol6") |>
  # start plotting
  tidyplot(x = condition, y = expression, color = sample_type) |>
  add_mean_dash() |>
  add_sem_errorbar() |>
  add_data_points() |>
  add_test_pvalue(hide.ns = TRUE)

# Adjust top padding for statistical comparisons
study |>
  tidyplot(x = treatment, y = score, color = treatment) |>
  add_mean_dash() |>
  add_sem_errorbar() |>
  add_data_points() |>
  add_test_pvalue(padding_top = 0.08)

# Hide stats information
study |>
  tidyplot(x = dose, y = score, color = group) |>
  add_mean_dash() |>
  add_sem_errorbar() |>
  add_data_points() |>
  add_test_pvalue(hide_info = TRUE)

}
