% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/separate_tags.R
\name{separate_tags}
\alias{separate_tags}
\title{Separate locus tag into multiple rows}
\usage{
separate_tags(txt, pattern, column = "text")
}
\arguments{
\item{txt}{a table}

\item{pattern}{regular expression to match locus tags like YPO[0-9-]+ or
the locus tag prefix like YPO.}

\item{column}{column name to search, default "text"}
}
\value{
a tibble with locus tag, matching text and rows.
}
\description{
Separates locus tags mentioned in full text and expands ranges like
YPO1970-74 into new rows
}
\examples{
x <- data.frame(row = 1, text = "some genes like YPO1002 and YPO1970-74")
separate_tags(x, "YPO")
}
\author{
Chris Stubben
}
