% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/answer_using_tools.R
\name{tools_get_docs}
\alias{tools_get_docs}
\title{Extract documentation from a function}
\usage{
tools_get_docs(func, name = NULL)
}
\arguments{
\item{func}{A function object. The function should belong to a package
and have documentation available in a help file, or it should
have documentation added by \code{\link[=tools_add_docs]{tools_add_docs()}}}

\item{name}{The name of the function if already known (optional).
If not provided it will be extracted from the documentation or the
function object's name}
}
\value{
A list with documentation for the function. See \code{\link[=tools_add_docs]{tools_add_docs()}}
for more information on the contents
}
\description{
This function extracts documentation from a help file (if available,
i.e., when the function is part of a package) or from documentation added
by \code{\link[=tools_add_docs]{tools_add_docs()}}. The extracted documentation includes
the function's name, description, arguments, and return value.
This information is used to provide an LLM with information about the functions,
so that the LLM can call R functions.
}
\details{
This function will prioritize documentation added by
\code{\link[=tools_add_docs]{tools_add_docs()}} over documentation from a help file.
Thus, it is possible to override the help file documentation by adding
custom documentation
}
\examples{
\dontrun{
  # When using functions from base R or R packages,
  #   documentation is automatically extracted from help files:
  "What are the files in my current directory?" |>
    answer_using_tools(dir) |> # 'dir' function is from base R
    send_prompt()
}

# Custom functions may also be provided;
#   in this case, some documentation is extracted from the function's formals;
#   descriptions may be added manually. See below

# Example fake weather function to add to the prompt:
temperature_in_location <- function(
    location = c("Amsterdam", "Utrecht", "Enschede"),
    unit = c("Celcius", "Fahrenheit")
) {
  location <- match.arg(location)
  unit <- match.arg(unit)

  temperature_celcius <- switch(
    location,
    "Amsterdam" = 32.5,
    "Utrecht" = 19.8,
    "Enschede" = 22.7
  )

  if (unit == "Celcius") {
    return(temperature_celcius)
  } else {
    return(temperature_celcius * 9/5 + 32)
  }
}

# Generate documentation for a function
#   (based on formals, & help file if available)
docs <- tools_get_docs(temperature_in_location)

# The types get inferred from the function's formals
# However, descriptions are still missing as the function is not from a package
# We can modify the documentation object to add descriptions:
docs$description <- "Get the temperature in a location"
docs$arguments$unit$description <- "Unit in which to return the temperature"
docs$arguments$location$description <- "Location for which to return the temperature"
docs$return$description <- "The temperature in the specified location and unit"
# (See `?tools_add_docs` for more details on the structure of the documentation)

# When we are satisfied with the documentation, we can add it to the function:
temperature_in_location <- tools_add_docs(temperature_in_location, docs)

\dontrun{
  # Now the LLM can use the function:
  "Hi, what is the weather in Enschede? Give me Celcius degrees" |>
    answer_using_tools(temperature_in_location) |>
    send_prompt()
}
}
\seealso{
Other tools: 
\code{\link{answer_using_tools}()},
\code{\link{tools_add_docs}()}
}
\concept{tools}
