% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/answer_as_category.R
\name{answer_as_multi_category}
\alias{answer_as_multi_category}
\title{Build prompt for categorizing a text into multiple categories
For single category, see \code{\link[=answer_as_category]{answer_as_category()}}}
\usage{
answer_as_multi_category(prompt, categories, descriptions = NULL)
}
\arguments{
\item{prompt}{A single string or a \code{\link[=tidyprompt]{tidyprompt()}} object}

\item{categories}{A character vector of category names. Must not be empty
and must not contain duplicates}

\item{descriptions}{An optional character vector of descriptions,
corresponding to each category. If provided, its length must match
the length of \code{categories}. Defaults to \code{NULL}}
}
\value{
A \code{\link[=tidyprompt]{tidyprompt()}} with an added \code{\link[=prompt_wrap]{prompt_wrap()}} which
will ensure that the LLM response is a vector of fitting categories of a text
}
\description{
Build prompt for categorizing a text into multiple categories
For single category, see \code{\link[=answer_as_category]{answer_as_category()}}
}
\examples{
\dontrun{
  "It is sunny, that makes me happy." |>
    answer_as_multi_category(
      categories = c("environment", "weather", "work", "positive", "negative")
    ) |>
    send_prompt()
  # --- Sending request to LLM provider (llama3.1:8b): ---
  #   You need to categorize a text.
  #
  # Text:
  #   'It is sunny, that makes me happy.'
  #
  # Possible categories:
  #   1. environment
  #   2. weather
  #   3. work
  #   4. positive
  #   5. negative
  #
  # Respond with the numbers of all categories that apply to this text, separated by commas.
  # (Use no other words or characters.)
  # --- Receiving response from LLM provider: ---
  #   2, 4
  # ["weather","positive"]
}
}
\seealso{
Other pre_built_prompt_wraps: 
\code{\link{add_text}()},
\code{\link{answer_as_boolean}()},
\code{\link{answer_as_category}()},
\code{\link{answer_as_integer}()},
\code{\link{answer_as_json}()},
\code{\link{answer_as_list}()},
\code{\link{answer_as_named_list}()},
\code{\link{answer_as_regex_match}()},
\code{\link{answer_as_text}()},
\code{\link{answer_by_chain_of_thought}()},
\code{\link{answer_by_react}()},
\code{\link{answer_using_r}()},
\code{\link{answer_using_sql}()},
\code{\link{answer_using_tools}()},
\code{\link{prompt_wrap}()},
\code{\link{quit_if}()},
\code{\link{set_system_prompt}()}

Other answer_as_prompt_wraps: 
\code{\link{answer_as_boolean}()},
\code{\link{answer_as_category}()},
\code{\link{answer_as_integer}()},
\code{\link{answer_as_json}()},
\code{\link{answer_as_list}()},
\code{\link{answer_as_named_list}()},
\code{\link{answer_as_regex_match}()},
\code{\link{answer_as_text}()}
}
\concept{answer_as_prompt_wraps}
\concept{pre_built_prompt_wraps}
