% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{query}
\alias{query}
\title{Query an R data frame with SQL}
\usage{
query(data, sql)
}
\arguments{
\item{data}{a data frame or data frame-like object (optional)}

\item{sql}{a character string containing a SQL \code{SELECT} statement}
}
\value{
An object of the same class as \code{data}.
}
\description{
\code{query} takes a SQL \code{SELECT} statement and uses it to
  query an R data frame
}
\details{
If the \code{data} argument is not specified, then the \code{FROM}
  clause of the SQL statement determines which data frame to query.

  The names of data frames and columns are case-sensitive (like in R).
  Keywords and function names are not case-sensitive (like in SQL).

  In addition to R data frames and tibbles (\code{tbl_df} objects), this
  function can query \code{dtplyr_step} objects created by \pkg{dtplyr}, a
  \pkg{data.table} backend for \pkg{dbplyr}. It is also possible to use this
  function together with \pkg{dbplyr} to query remote database tables
  (\code{tbl_sql} objects), but this depends on which database and which
  backend package (if any) you are using, so results may vary.

  This function is subject to the
  \href{https://cran.r-project.org/package=queryparser/readme/README.html#current-limitations}{current
  limitations of the \pkg{queryparser} package}.
}
\examples{
library(dplyr)

iris \%>\% query("SELECT Species, AVG(Petal.Length) GROUP BY Species")

query("SELECT Species, AVG(Petal.Length) FROM iris GROUP BY Species")

iris \%>\%
  filter(Petal.Length > 4) \%>\%
  query("SELECT Species, MAX(Sepal.Length) AS max_sep_len
           GROUP BY Species") \%>\%
  arrange(desc(max_sep_len))

library(nycflights13)

query <- "SELECT origin, dest,
    COUNT(flight) AS num_flts,
    round(AVG(distance)) AS dist,
    round(AVG(arr_delay)) AS avg_delay
  FROM flights
  WHERE distance BETWEEN 200 AND 300
    AND air_time IS NOT NULL
  GROUP BY origin, dest
  HAVING num_flts > 5000
  ORDER BY num_flts DESC, avg_delay DESC
  LIMIT 100;"

query(query)
}
