% Generated by roxygen2 (4.0.1): do not edit by hand
\name{spread}
\alias{spread}
\title{Spread a key-value pair across multiple columns.}
\usage{
spread(data, key, value, fill = NA, convert = FALSE)
}
\arguments{
\item{key,value}{Bare (unquoted) names of key and value columns.}

\item{data}{A data frame.}

\item{fill}{If there isn't a value for every combination of the other
variables and the key column, this value will be substituted.}

\item{convert}{If \code{TRUE}, \code{\link{type.convert}} with
\code{asis = TRUE} will be run on each of the new columns. This is
useful if the value column was a mix of variables that was coerced to
a string.}
}
\description{
Spread a key-value pair across multiple columns.
}
\examples{
library(dplyr)
stocks <- data.frame(
  time = as.Date('2009-01-01') + 0:9,
  X = rnorm(10, 0, 1),
  Y = rnorm(10, 0, 2),
  Z = rnorm(10, 0, 4)
)
stocksm <- stocks \%>\% gather(stock, price, -time)
stocksm \%>\% spread(stock, price)
stocksm \%>\% spread(time, price)

# Spread and gather are complements
df <- data.frame(x = c("a", "b"), y = c(3, 4), z = c(5, 6))
df \%>\% spread(x, y) \%>\% gather(x, y, a:b, na.rm = TRUE)
}

