% Generated by roxygen2 (4.0.2): do not edit by hand
\name{gather}
\alias{gather}
\title{Gather columns into key-value pairs.}
\usage{
gather(data, key, value, ..., na.rm = FALSE, convert = FALSE)
}
\arguments{
\item{data}{A data frame.}

\item{key,value}{Names of key and value columns to create in output.}

\item{...}{Specification of columns to gather. Use bare variable names.
Select all variables between x and z with \code{x:z}, exclude y with
\code{-y}. For more options, see the \link[dplyr]{select} documentation.}

\item{na.rm}{If \code{TRUE}, will remove rows from output where the
value column in \code{NA}.}

\item{convert}{If \code{TRUE} will automatically run
\code{\link{type.convert}} on the key column. This is useful if the column
names are actually numeric, integer, or logical.}
}
\description{
Gather takes multiple columns and collapses into key-value pairs,
duplicating all other columns as needed. You use \code{gather()} when
you notice that you have columns that are not variables.
}
\examples{
library(dplyr)
# From http://stackoverflow.com/questions/1181060
stocks <- data.frame(
  time = as.Date('2009-01-01') + 0:9,
  X = rnorm(10, 0, 1),
  Y = rnorm(10, 0, 2),
  Z = rnorm(10, 0, 4)
)

gather(stocks, stock, price, -time)
stocks \%>\% gather(stock, price, -time)
}
\seealso{
\code{\link{gather_}} for a version that uses regular evaluation
  and is suitable for programming with.
}

