% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complete.R
\name{complete}
\alias{complete}
\title{Complete a data frame with missing combinations of data}
\usage{
complete(data, ..., fill = list())
}
\arguments{
\item{data}{A data frame.}

\item{...}{Specification of columns to expand. Columns can be atomic vectors
or lists.

To find all unique combinations of x, y and z, including those not
found in the data, supply each variable as a separate argument.
To find only the combinations that occur in the data, use nest:
\code{expand(df, nesting(x, y, z))}.

You can combine the two forms. For example,
\code{expand(df, nesting(school_id, student_id), date)} would produce
a row for every student for each date.

For factors, the full set of levels (not just those that appear in the
data) are used. For continuous variables, you may need to fill in values
that don't appear in the data: to do so use expressions like
\code{year = 2010:2020} or \code{year = \link{full_seq}(year,1)}.

Length-zero (empty) elements are automatically dropped.}

\item{fill}{A named list that for each variable supplies a single value to
use instead of \code{NA} for missing combinations.}
}
\description{
Turns implicit missing values into explicit missing values.
This is a wrapper around \code{\link[=expand]{expand()}},
\code{\link[dplyr:left_join]{dplyr::left_join()}} and \code{\link[=replace_na]{replace_na()}} that's
useful for completing missing combinations of data.
}
\details{
If you supply \code{fill}, these values will also replace existing
explicit missing values in the data set.
}
\examples{
library(dplyr, warn.conflicts = FALSE)
df <- tibble(
  group = c(1:2, 1),
  item_id = c(1:2, 2),
  item_name = c("a", "b", "b"),
  value1 = 1:3,
  value2 = 4:6
)
df \%>\% complete(group, nesting(item_id, item_name))

# You can also choose to fill in missing values
df \%>\% complete(group, nesting(item_id, item_name), fill = list(value1 = 0))
}
