% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_pres_vs_bg.R
\name{plot_pres_vs_bg}
\alias{plot_pres_vs_bg}
\title{Plot presences vs background}
\usage{
plot_pres_vs_bg(.data, .col)
}
\arguments{
\item{.data}{a \code{\link{data.frame}} (or derived object, such as \code{\link[tibble:tibble]{tibble::tibble}},
or \code{\link[sf:sf]{sf::st_sf}}) with values for the bioclimate variables for presences
and background}

\item{.col}{the column containing the presences; it assumes presences to be
the first level of this factor}
}
\value{
a \code{patchwork} composite plot
}
\description{
Create a composite plots contrasting the distribution of multiple variables
for presences vs the background.
}
\examples{
data("bradypus", package = "maxnet")
bradypus_tb <- tibble::as_tibble(bradypus) \%>\%
  dplyr::mutate(presence = relevel(
    factor(
      dplyr::case_match(presence, 1 ~ "presence", 0 ~ "absence")
    ),
    ref = "presence"
  )) \%>\%
  select(-ecoreg)

bradypus_tb \%>\% plot_pres_vs_bg(presence)
}
