% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_methods.R
\name{rename}
\alias{rename}
\title{Rename columns}
\usage{
rename(.data, ...)
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g. a tibble), or a
lazy data frame (e.g. from dbplyr or dtplyr). See *Methods*, below, for
more details.}

\item{...}{<[`tidy-select`][dplyr_tidy_select]> Use `new_name = old_name`
to rename selected variables.}
}
\value{
An object of the same type as `.data`.
* Rows are not affected.
* Column names are changed; column order is preserved
* Data frame attributes are preserved.
* Groups are updated to reflect new names.
}
\description{
Rename individual variables using `new_name = old_name` syntax.
}
\section{Scoped selection and renaming}{


Use the three scoped variants ([rename_all()], [rename_if()], [rename_at()])
to renaming a set of variables with a function.
}

\section{Methods}{

This function is a **generic**, which means that packages can provide
implementations (methods) for other classes. See the documentation of
individual methods for extra arguments and differences in behaviour.

The following methods are currently available in loaded packages:
}

\examples{
`\%>\%` = magrittr::`\%>\%`
pbmc_small \%>\% tidy \%>\% rename(s_score = nFeature_RNA) 

}
\seealso{
Other single table verbs: 
\code{\link{arrange}()},
\code{\link{filter}()},
\code{\link{mutate}()},
\code{\link{select}()},
\code{\link{slice}()},
\code{\link{summarise}()}
}
\concept{single table verbs}
