% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collapse.R
\name{collapse}
\alias{collapse}
\alias{collapse.sq}
\title{Collapse multiple sequences into one}
\usage{
collapse(x, ...)

\method{collapse}{sq}(x, ..., NA_letter = getOption("tidysq_NA_letter"))
}
\arguments{
\item{x}{[\code{sq}]\cr
An object this function is applied to.}

\item{...}{further arguments to be passed from or to other methods.}

\item{NA_letter}{[\code{character(1)}]\cr
A string that is used to interpret and display \code{NA} value in the
context of \code{\link[=sq-class]{sq class}}. Default value equals to
"\code{!}".}
}
\value{
\code{\link[=sq-class]{sq}} object of the same type as input but with
exactly one sequence.
}
\description{
Joins sequences from a vector into a single sequence. Sequence
type remains unchanged.
}
\details{
\code{collapse()} joins sequences from supplied \code{sq} object in the same
order as they appear in said vector. That is, if there are three sequences
AGGCT, ATCCGT and GAACGT, then resulting sequence will be AGGCTATCCGTGAACGT.
This operation does not alter the type of the input object nor its alphabet.
}
\examples{
# Creating objects to work on:
sq_ami <- sq(c("MIAANYTWIL","TIAALGNIIYRAIE", "NYERTGHLI", "MAYXXXIALN"),
             alphabet = "ami_ext")
sq_dna <- sq(c("ATGCAGGA", "GACCGAACGAN", ""), alphabet = "dna_ext")
sq_unt <- sq(c("ATGCAGGA?", "TGACGAGCTTA", "", "TIAALGNIIYRAIE"))

# Collapsing sequences:
collapse(sq_ami)
collapse(sq_dna)
collapse(sq_unt)

# Empty sq objects are collapsed as well (into empty string - ""):
sq_empty <- sq(character(), alphabet = "rna_bsc")
collapse(sq_empty)

}
\seealso{
Functions that affect order of elements:
\code{\link{bite}()},
\code{\link{paste}()},
\code{\link{reverse}()}
}
\concept{order_functions}
