% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count.R
\name{count.}
\alias{count.}
\title{Count observations by group}
\usage{
count.(.df, ..., wt = NULL, sort = FALSE, name = NULL)
}
\arguments{
\item{.df}{A data.frame or data.table}

\item{...}{Columns to group by in \code{count()}. \code{tidyselect} compatible.}

\item{wt}{Frequency weights.  \code{tidyselect} compatible.
Can be \code{NULL} or a variable:
\itemize{
\item If \code{NULL} (the default), counts the number of rows in each group.
\item If a variable, computes \code{sum(wt)} for each group.
}}

\item{sort}{If \code{TRUE}, will show the largest groups at the top.}

\item{name}{The name of the new column in the output.

If omitted, it will default to \code{n}.}
}
\description{
Returns row counts of the dataset.

\code{tally()} returns counts by group on a grouped tidytable.

\code{count()} returns counts by group on a grouped tidytable, or column names can be specified
to return counts by group.
}
\examples{
df <- data.table(
  x = c("a", "a", "b"),
  y = c("a", "a", "b"),
  z = 1:3
)

df \%>\%
  count()

df \%>\%
  count(x)

df \%>\%
  count(where(is.character))

df \%>\%
  count(x, wt = z, name = "x_sum")

df \%>\%
  count(x, sort = TRUE)

df \%>\%
  tally()

df \%>\%
  group_by(x) \%>\%
  tally()
}
\keyword{internal}
