% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unnest_wider.R
\name{unnest_wider.}
\alias{unnest_wider.}
\title{Unnest a list-column of vectors into a wide data frame}
\usage{
unnest_wider.(
  .df,
  col,
  names_sep = NULL,
  simplify = NULL,
  names_repair = "check_unique",
  ptype = NULL,
  transform = NULL
)
}
\arguments{
\item{.df}{A data.table or data.frame}

\item{col}{Column to unnest}

\item{names_sep}{If \code{NULL}, the default, the names will be left as they are.
If a string, the inner and outer names will be pasted together with \code{names_sep}
as the separator.}

\item{simplify}{Currently not supported. Errors if not \code{NULL}.}

\item{names_repair}{Treatment of duplicate names. See \code{?vctrs::vec_as_names} for options/details.}

\item{ptype}{Optionally a named list of ptypes declaring the desired output type of each component.}

\item{transform}{Optionally a named list of transformation functions applied to each component.}
}
\description{
Unnest a list-column of vectors into a wide data frame
}
\examples{
df <- tidytable(
  x = 1:3,
  y = list(0, 1:3, 4:5)
)

# Automatically creates names
df \%>\% unnest_wider(y)

# But you can provide names_sep for increased naming control
df \%>\% unnest_wider(y, names_sep = "_")
}
\keyword{internal}
