% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize.R
\name{dt_summarize}
\alias{dt_summarize}
\alias{dt_summarise}
\title{Aggregate data using summary statistics}
\usage{
dt_summarize(.data, ..., by = NULL)

dt_summarise(.data, ..., by = NULL)
}
\arguments{
\item{.data}{A data.frame or data.table}

\item{...}{Aggregations to perform}

\item{by}{Optional: `list()` of bare column names to group by}
}
\description{
Aggregate data using summary statistics such as mean or median. Can be calculated by group.
}
\examples{
example_dt <- data.table::data.table(
  a = c(1,2,3),
  b = c(4,5,6),
  c = c("a","a","b"),
  d = c("a","a","b"))

example_dt \%>\%
  dt_summarize(avg_a = mean(a),
               max_b = max(b),
               by = c)

example_dt \%>\%
  dt_summarize(avg_a = mean(a),
               by = list(c, d))
}
