% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{filter.}
\alias{filter.}
\alias{dt_filter}
\title{Filter rows on one or more conditions}
\usage{
filter.(.data, ..., by = NULL)

dt_filter(.data, ..., by = NULL)
}
\arguments{
\item{.data}{A data.frame or data.table}

\item{...}{Conditions to filter by}

\item{by}{Columns to group by if filtering with a summary function}
}
\description{
Filters a dataset to choose rows where conditions are true.
}
\examples{
example_dt <- tidytable(
  a = c(1,2,3),
  b = c(4,5,6),
  c = c("a","a","b"))

example_dt \%>\%
  filter.(a >= 2, b >= 4)

example_dt \%>\%
  filter.(b <= mean(b), by = c)
}
