% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutate_variants.R
\name{mutate_if.}
\alias{mutate_if.}
\alias{mutate_at.}
\alias{mutate_all.}
\alias{dt_mutate_if}
\alias{dt_mutate_at}
\alias{dt_mutate_all}
\title{Deprecated mutate helpers}
\usage{
mutate_if.(.df, .predicate, .funs, ..., .by = NULL, by = NULL)

mutate_at.(.df, .vars, .funs, ..., .by = NULL, by = NULL)

mutate_all.(.df, .funs, ..., .by = NULL, by = NULL)

dt_mutate_if(.df, .predicate, .funs, ..., .by = NULL, by = NULL)

dt_mutate_at(.df, .vars, .funs, ..., .by = NULL, by = NULL)

dt_mutate_all(.df, .funs, ..., .by = NULL, by = NULL)
}
\arguments{
\item{.df}{A data.frame or data.table}

\item{.predicate}{predicate for \code{mutate_if.()} to use}

\item{.funs}{Functions to pass. Can pass a list of functions.}

\item{...}{Other arguments for the passed function}

\item{.by}{Columns to group by}

\item{by}{This argument has been renamed to .by and is deprecated}

\item{.vars}{vector \code{c()} of bare column names for \code{mutate_at.()} to use}
}
\description{
These helpers have been deprecated. Please use \code{mutate_across.()}
}
\examples{
test_df <- data.table(
  x = c(1,1,1),
  y = c(2,2,2),
  z = c("a", "a", "b"))

test_df \%>\%
  mutate_across.(where(is.numeric), as.character)

test_df \%>\%
  mutate_across.(c(x, y), ~ .x * 2)

test_df \%>\%
  mutate_across.(everything(), as.character)

test_df \%>\%
  mutate_across.(c(x, y), list(new = ~ .x * 2,
                               another = ~ .x + 7))
}
