% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distinct.R
\name{distinct.}
\alias{distinct.}
\title{Select distinct/unique rows}
\usage{
distinct.(.df, ..., .keep_all = FALSE)
}
\arguments{
\item{.df}{A data.frame or data.table}

\item{...}{Columns to select before determining uniqueness. If omitted, will use all columns.
\code{tidyselect} compatible.}

\item{.keep_all}{Only relevant if columns are provided to ... arg.
This keeps all columns, but only keeps the first row of each distinct
values of columns provided to ... arg.}
}
\description{
Retain only unique/distinct rows from an input df.
}
\examples{
df <- tidytable(
  x = 1:3,
  y = 4:6,
  z = c("a", "a", "b")
)

df \%>\%
  distinct.()

df \%>\%
  distinct.(z)
}
