% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_dummies.R
\name{get_dummies.}
\alias{get_dummies.}
\title{Convert character and factor columns to dummy variables}
\usage{
get_dummies.(
  .df,
  cols = where(~is.character(.x) | is.factor(.x)),
  prefix = TRUE,
  prefix_sep = "_",
  drop_first = FALSE,
  dummify_na = TRUE
)
}
\arguments{
\item{.df}{A data.frame or data.table}

\item{cols}{A single column or a vector of unquoted columns to dummify.
Defaults to all character & factor columns using \code{c(where(is.character), where(is.factor))}.
\code{tidyselect} compatible.}

\item{prefix}{TRUE/FALSE - If TRUE, a prefix will be added to new column names}

\item{prefix_sep}{Separator for new column names}

\item{drop_first}{TRUE/FALSE - If TRUE, the first dummy column will be dropped}

\item{dummify_na}{TRUE/FALSE - If TRUE, NAs will also get dummy columns}
}
\description{
Convert character and factor columns to dummy variables
}
\examples{
df <- tidytable(
  chr = c("a", "b", NA),
  fct = as.factor(c("a", NA, "c")),
  num = 1:3
)

# Automatically does all character/factor columns
df \%>\%
  get_dummies.()

df \%>\%
  get_dummies.(cols = chr)

df \%>\%
  get_dummies.(cols = c(chr, fct), drop_first = TRUE)

df \%>\%
  get_dummies.(prefix_sep = ".", dummify_na = FALSE)
}
