% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop_na.Spat.R
\name{drop_na.SpatVector}
\alias{drop_na.SpatVector}
\title{Drop attributes of SpatVector objects containing missing values}
\usage{
\method{drop_na}{SpatVector}(data, ...)
}
\arguments{
\item{data}{A SpatVector created with \code{\link[terra:vect]{terra::vect()}}.}

\item{...}{\code{\link[tidyr:drop_na]{tidy-select}}  Attributes to inspect for
missing values. If empty, all attributes are used.}
}
\value{
A Spat* object  of the same class than \code{.data}. See \strong{Methods}.
}
\description{
\code{drop_na()} method drops geometries where any attribute specified by \code{...}
contains a missing value.
}
\section{Methods}{


Implementation of the \strong{generic} \code{\link[tidyr:drop_na]{tidyr::drop_na()}} function.
\subsection{SpatVector}{

The implementation of this method is performed on a \code{by-attribute} basis,
meaning that \code{NAs} are assessed on the attributes (columns) of each vector
(rows). The result is a SpatVector with potentially less geometries than the
input
}
}

\examples{

library(terra)

f <- system.file("extdata/cyl.gpkg", package = "tidyterra")

v <- terra::vect(f)

# Add NAs
v <- v \%>\% mutate(iso2 = ifelse(cpro <= "09", NA, cpro))

# Init
plot(v, col = "red")

# Mask with lyr.1
v \%>\%
  drop_na(iso2) \%>\%
  plot(col = "red")
}
\seealso{
\code{\link[tidyr:drop_na]{tidyr::drop_na()}}. \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#questioning}{\figure{lifecycle-questioning.svg}{options: alt='[Questioning]'}}}{\strong{[Questioning]}} A method for
SpatRaster is also available, see \code{\link[=drop_na.SpatRaster]{drop_na.SpatRaster()}}.

Other tidyr.methods: 
\code{\link{replace_na.Spat}}
}
\concept{tidyr.methods}
