% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select-Spat.R
\name{select.Spat}
\alias{select.Spat}
\alias{select.SpatRaster}
\alias{select.SpatVector}
\title{Subset layers/attributes of Spat* objects}
\usage{
\method{select}{SpatRaster}(.data, ...)

\method{select}{SpatVector}(.data, ...)
}
\arguments{
\item{.data}{A SpatRaster created with \code{\link[terra:rast]{terra::rast()}} or a SpatVector
created with \code{\link[terra:vect]{terra::vect()}}.}

\item{...}{\code{\link[dplyr:select]{tidy-select}} One or more unquoted expressions
separated by commas. Layer/attribute names can be used as if they were
positions in the Spat* object, so expressions like x:y can be used to
select a range of layers/attributes.}
}
\value{
A Spat* object  of the same class than \code{.data}. See \strong{Methods}.
}
\description{
Select (and optionally rename) attributes/layers in Spat* objects, using a
concise mini-language. See \strong{Methods}.
}
\section{terra equivalent}{


\code{\link[terra:subset]{terra::subset()}}
}

\section{Methods}{


Implementation of the \strong{generic} \code{\link[dplyr:select]{dplyr::select()}} function.
\subsection{SpatRaster}{

Select (and rename) layers of a SpatRaster. The result is a
SpatRaster with the same extent, resolution and crs than \code{.data}. Only the
number (and possibly the name) of layers is modified.
}

\subsection{SpatVector}{

The result is a SpatVector with the selected (and possibly renamed)
attributes on the function call.
}
}

\examples{

library(terra)

# SpatRaster method

spatrast <- rast(
  crs = "epsg:3857",
  nrows = 10,
  ncols = 10,
  extent = c(100, 200, 100, 200),
  nlyr = 6,
  vals = seq_len(10 * 10 * 6)
)

spatrast \%>\% select(1)

# By name
spatrast \%>\% select(lyr.1:lyr.4)

# Rename
spatrast \%>\% select(a = lyr.1, c = lyr.6)

# SpatVector method

f <- system.file("extdata/cyl.gpkg", package = "tidyterra")

v <- vect(f)

v

v \%>\% select(1, 3)

v \%>\% select(iso2, name2 = cpro)
}
\seealso{
\code{\link[dplyr:select]{dplyr::select()}}, \code{\link[terra:subset]{terra::subset()}}

Other single table verbs: 
\code{\link{arrange.SpatVector}()},
\code{\link{filter.Spat}},
\code{\link{mutate.Spat}},
\code{\link{rename.Spat}},
\code{\link{slice.Spat}},
\code{\link{summarise.SpatVector}()}

Other dplyr verbs that operate on columns:
\code{\link{glimpse.Spat}},
\code{\link{mutate.Spat}},
\code{\link{pull.Spat}},
\code{\link{relocate.Spat}},
\code{\link{rename.Spat}}

Other dplyr methods:
\code{\link{arrange.SpatVector}()},
\code{\link{bind_cols.SpatVector}},
\code{\link{bind_rows.SpatVector}},
\code{\link{count.SpatVector}()},
\code{\link{distinct.SpatVector}()},
\code{\link{filter-joins.SpatVector}},
\code{\link{filter.Spat}},
\code{\link{glimpse.Spat}},
\code{\link{group-by.SpatVector}},
\code{\link{mutate-joins.SpatVector}},
\code{\link{mutate.Spat}},
\code{\link{pull.Spat}},
\code{\link{relocate.Spat}},
\code{\link{rename.Spat}},
\code{\link{rowwise.SpatVector}()},
\code{\link{slice.Spat}},
\code{\link{summarise.SpatVector}()}
}
\concept{dplyr.cols}
\concept{dplyr.methods}
\concept{single table verbs}
