% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lump.R
\name{lump}
\alias{lump}
\title{Generic lumping}
\usage{
lump(levels, count, n, prop, other_level = "Other", ties.method = c("min",
  "average", "first", "last", "random", "max"))
}
\arguments{
\item{levels}{Vector of levels}

\item{count}{Vector of corresponding counts}

\item{n}{If specified, n rows shall be preserved.}

\item{prop}{If specified, rows shall be preserved if their count >= prop}

\item{other_level}{Name of the "other" level to be created from lumped rows}

\item{ties.method}{Method to apply in case of ties}
}
\value{
A dictionary (named vector) of levels -> new levels
}
\description{
Takes levels (labels, factor levels) and corresponding counts
and "lumps" according to specified criteria (either n or prop), i.e.
preserves some rows and summarises the rest in a single "Other" row
}
