% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/purrr-like.R
\name{lookup}
\alias{lookup}
\alias{lookup_int}
\alias{lookup_chr}
\alias{lookup_lgl}
\alias{lookup_dbl}
\alias{lookup_num}
\title{Lookup in a dictionary}
\usage{
lookup(dict, ..., default = NA, dict_key_is_regex = F,
  key_is_regex = F)

lookup_int(dict, ..., default = NA, dict_key_is_regex = F,
  key_is_regex = F)

lookup_chr(dict, ..., default = NA, dict_key_is_regex = F,
  key_is_regex = F)

lookup_lgl(dict, ..., default = NA, dict_key_is_regex = F,
  key_is_regex = F)

lookup_dbl(dict, ..., default = NA, dict_key_is_regex = F,
  key_is_regex = F)

lookup_num(dict, ..., default = NA, dict_key_is_regex = F,
  key_is_regex = F)
}
\arguments{
\item{dict}{A dictionaryish vector (named: key -> value)}

\item{...}{Keys to lookup in the dictionary}

\item{default}{Default value to return if key is not found. Can be a value or function (called with the key).
Note: default is to return NA; another very intuitive case is to return the key itself.
To achieve this, pass \code{default = identity}.}

\item{dict_key_is_regex}{Should the dictionary keys, the names of dict,
be regarded as regular expressions? (excludes key_is_regex)}

\item{key_is_regex}{Should the keys to lookup be regarded as regular expressions? (excludes dict_key_is_regex)}
}
\value{
A list of the same size as ..., containing the lookup results. For the type-specific functions,
        returns a vector typed as requested, requiring all lookup results to have matching type.
}
\description{
Looks up all values as keys of the dictionary and returns the values.
}
\examples{
a <- list("x", "y", "z")
dict <- c(x="xc", y="yv")
# returns c("xc", "yv", na_chr)
lookup_chr(dict, a)#'
# returns c("xc", "yv", "z")
lookup_chr(dict, "x", "y", "z", default=identity)
}
