% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind_table.R
\name{bind_table}
\alias{bind_table}
\title{Bind a set of tidytlg tables together with formatting variables}
\usage{
bind_table(
  ...,
  colvar = NULL,
  tablebyvar = NULL,
  rowbyvar = NULL,
  prefix = NULL,
  add_count = FALSE,
  add_format = TRUE,
  column_metadata_file = NULL,
  column_metadata = NULL,
  tbltype = NULL
)
}
\arguments{
\item{...}{(required) a set of tidytlg tables to bind together}

\item{colvar}{(required) treatment variable within df to use to summarize.
Required if \code{add_count} is TRUE.}

\item{tablebyvar}{(optional) repeat entire table by variable within df}

\item{rowbyvar}{(optional) any rowbyvar values used to create the table}

\item{prefix}{(optional) text to prefix the values of tablebyvar with}

\item{add_count}{(optional) Should a count be included in the tablebyvar?
(default = TRUE)}

\item{add_format}{(optional) Should format be added to the output table?
This is done using the add_format function. (default = TRUE)}

\item{column_metadata_file}{(optional) An excel file for column_metadata.
Does not change the behavior of the function binds the column metadata
for \code{gentlg}. If a column_metadata dataframe is passed in too,
this is ignored.}

\item{column_metadata}{(optional) A dataframe containing the column metadata.
This will be used in place of column_metadata_file.}

\item{tbltype}{(optional) A value used to subset the column_metadata_file.}
}
\value{
The tidytlg tables bound together reflecting the tablebyvars used
}
\description{
bind_table combines analysis results with formatting variables (indentme, newrows, newpage)
based on by variables (tablebyvar, rowbyvar), such that appropriate formatting (indentation,
line break, page break) can be applied in creating the output. It can also attach the column
metadata attribute, which will be automatically used in \code{gentlg} for creating output.
}
\examples{
library(magrittr)

# bind tables together
t1 <- cdisc_adsl \%>\%
  freq(colvar = "TRT01PN",
       rowvar = "ITTFL",
       statlist = statlist("n"),
       subset = ITTFL == "Y",
       rowtext = "Analysis set: ITT")

t2 <- cdisc_adsl \%>\%
  univar(colvar = "TRT01PN",
         rowvar = "AGE",
         decimal = 0,
         row_header = "Age, years")

bind_table(t1, t2)

# bind tables together w/by groups
t1 <- cdisc_adsl \%>\%
  freq(colvar = "TRT01PN",
       rowvar = "ITTFL",
       rowbyvar = "SEX",
       statlist = statlist("n"),
       subset = ITTFL == "Y",
       rowtext = "Analysis set: ITT")

t2 <- cdisc_adsl \%>\%
  univar(colvar = "TRT01PN",
         rowvar = "AGE",
         rowbyvar = "SEX",
         decimal = 0,
         row_header = "Age, years")

bind_table(t1, t2, rowbyvar = "SEX")

# bind tables together w/table by groups
t1 <- cdisc_adsl \%>\%
  freq(colvar = "TRT01PN",
       rowvar = "ITTFL",
       tablebyvar = "SEX",
       statlist = statlist("n"),
       subset = ITTFL == "Y",
       rowtext = "Analysis set: ITT")

t2 <- cdisc_adsl \%>\%
  univar(colvar = "TRT01PN",
         rowvar = "AGE",
         tablebyvar = "SEX",
         decimal = 0,
         row_header = "Age, years")

bind_table(t1, t2, tablebyvar = "SEX")

# w/prefix
bind_table(t1, t2, tablebyvar = "SEX", prefix = "Gender: ")

# w/counts
bind_table(t1, t2, tablebyvar = "SEX", add_count = TRUE, colvar = "TRT01PN")
}
