% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo.R
\name{stop_distances}
\alias{stop_distances}
\title{Calculate distances between a given set of stops}
\usage{
stop_distances(gtfs_stops)
}
\arguments{
\item{gtfs_stops}{gtfs stops table either as data frame (with at least \code{stop_id},
\code{stop_lon} and \code{stop_lat} columns) or as \code{sf} object.}
}
\value{
Returns a data.frame with each row containing a pair of stop_ids (columns
\code{from_stop_id} and \code{to_stop_id}) and the \code{distance} between them (in meters)
}
\description{
Calculate distances between a given set of stops
}
\note{
The resulting data.frame has \code{nrow(gtfs_stops)^2} rows, distances calculations
among all stops for large feeds should be avoided.
}
\examples{
\dontrun{
library(dplyr)

nyc_path <- system.file("extdata", "nyc_subway.zip", package = "tidytransit")
nyc <- read_gtfs(nyc_path)

nyc$stops \%>\%
  filter(stop_name == "Borough Hall") \%>\%
  stop_distances() \%>\%
  arrange(desc(distance))

#> # A tibble: 36 × 3
#>    from_stop_id to_stop_id  distance
#>    <chr>        <chr>          <dbl>
#>  1 423          232             91.5
#>  2 423N         232             91.5
#>  3 423S         232             91.5
#>  4 423          232N            91.5
#>  5 423N         232N            91.5
#>  6 423S         232N            91.5
#>  7 423          232S            91.5
#>  8 423N         232S            91.5
#>  9 423S         232S            91.5
#> 10 232          423             91.5
#> # … with 26 more rows
}
}
