% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vpcstats.R
\name{vpcstats}
\alias{vpcstats}
\alias{vpcstats.tidyvpcobj}
\title{vpcstats}
\usage{
vpcstats(o, ...)

\method{vpcstats}{tidyvpcobj}(
  o,
  qpred = c(0.05, 0.5, 0.95),
  ...,
  conf.level = 0.95,
  quantile.type = 7
)
}
\arguments{
\item{o}{tidyvpc object}

\item{...}{Other arguments to include}

\item{qpred}{Numeric vector of length 3 specifying quantile prediction interval}

\item{conf.level}{Numeric specifying confidence level}

\item{quantile.type}{Numeric indicating quantile type. See \code{\link[stats]{quantile}}}
}
\value{
Updates \code{tidyvpcobj} with \code{stats} \code{data.table} object which contains the following columns:
\itemize{
  \item \code{bin}: the resulting bin value as specified in `binning()` function
  \item \code{xbin}: the midpoint x-value of the observed data points in the bin as specified in `xbin` argument of `binning()` function
  \item \code{qname}: the quantiles specified in `qpred`
  \item \code{y}: the observed y value for the specified quantile
  \item \code{lo}: the lower bound of specified confidence interval for y value in simulated data
  \item \code{md}: the median y value in simulated data
  \item \code{hi}: the upper bound of specified confidence interval for y value in simulated data
}
}
\description{
Compute VPC statistics
}
\details{
Compute predictional interval statistics for VPC
}
\seealso{
\code{\link{observed}} \code{\link{simulated}} \code{\link{censoring}} \code{\link{stratify}} \code{\link{binning}} \code{\link{binless}} \code{\link{predcorrect}}
}
