% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vpcstats.R
\name{censoring}
\alias{censoring}
\alias{censoring.tidyvpcobj}
\title{Censoring observed data for Visual Predictive Check (VPC)}
\usage{
censoring(o, ...)

\method{censoring}{tidyvpcobj}(o, blq, lloq, alq, uloq, data = o$data, ...)
}
\arguments{
\item{o}{A \code{tidyvpcobj}.}

\item{...}{Other arguments to include.}

\item{blq}{blq variable if present in observed data.}

\item{lloq}{Numeric value or numeric variable in data indicating the upper limit of quantification.}

\item{alq}{Logical variable indicating above limit of quantification.}

\item{uloq}{Numeric value or numeric variable in data indicating the upper limit of quantification.}

\item{data}{Observed data supplied in \code{observed()} function.}
}
\value{
Updates \code{obs} \code{data.frame} in \code{tidypcobj} with censored values for observed data which includes \code{lloq} and \code{uloq} specified 
 values for lower/upper limit of quantification. Logicals for \code{blq} and \code{alq} are returned that indicate whether the DV value lies below/above limit 
 of quantification.
}
\description{
Specify censoring variable or censoring value for VPC.
}
\examples{
require(magrittr)

vpc <- observed(obs_data, x=TIME, y=DV) \%>\%
    simulated(sim_data, y=DV) \%>\%
    censoring(blq=(DV < 50), lloq=50) \%>\%
    binning(bin = "pam", nbins = 5) \%>\%
    vpcstats()

#Using LLOQ variable in data with different values of LLOQ by Study:

obs_data$LLOQ <- obs_data[, ifelse(STUDY == "Study A", 50, 25)]

vpc <- observed(obs_data, x=TIME, y=DV) \%>\%
    simulated(sim_data, y=DV) \%>\%
    censoring(blq=(DV < LLOQ), lloq=LLOQ) \%>\%
    stratify(~ STUDY) \%>\%
    binning(bin = "kmeans", nbins = 4) \%>\%
    vpcstats()

 
}
\seealso{
\code{\link{observed}} \code{\link{simulated}} \code{\link{stratify}} \code{\link{predcorrect}} \code{\link{binning}} \code{\link{binless}} \code{\link{vpcstats}}
}
