% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_get_cached_item.R
\name{tw_get_cached_item}
\alias{tw_get_cached_item}
\title{Retrieve cached item}
\usage{
tw_get_cached_item(id, language = "all_available")
}
\arguments{
\item{id}{A characther vector, must start with Q, e.g. "Q180099" for the anthropologist Margaret Mead. Can also be a data frame of one row, typically generated with \code{tw_search()} or a combination of \code{tw_search()} and \code{tw_filter_first()}.}

\item{language}{Defaults to "all_available". By default, returns dataset with labels in all available languages. If given, only in the chosen language. For available values, see https://www.wikidata.org/wiki/Help:Wikimedia_language_codes/lists/all}
}
\value{
If data present in cache, returns a data frame with cached data.
}
\description{
Retrieve cached item
}
\examples{


tw_set_cache_folder(path = tempdir())
tw_enable_cache()
tw_create_cache_folder(ask = FALSE)

df_from_api <- tw_get(id = "Q180099", language = "en")

df_from_cache <- tw_get_cached_item(
  id = "Q180099",
  language = "en"
)
}
