% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/qnormGC.R
\name{qnormGC}
\alias{qnormGC}
\title{Graphical Calculator for Normal Curve Percentiles}
\usage{
qnormGC(area,region="below",mean=0,sd=1,graph=FALSE)
}
\arguments{
\item{area}{The known percentile}

\item{region}{A character string.  Default is "below".  Other possible values are "between"
(when known area is symmetric around the mean two numbers),
"below", "above", and "outside" (when knonw area is outside a region symmetric around the mean)}

\item{mean}{Mean of the distribution}

\item{sd}{Standard deviation of the distribution}

\item{graph}{Will produce graph of the area}
}
\value{
Numerical value of the percentile, and a vector when there are two bounds.
}
\description{
When you know a certain area under a normal denisity durve, this function returns
the x-axis values of the boundary of that area.
}
\examples{
#80th percentile of a normal distribution with mean=70 and sd=4:
qnormGC(0.80,region="below",mean=70,sd=4)

#Return value x so that P(X > x) = 0.10 (same as the 90th percentile)
qnormGC(0.10,region="above",mean=70,sd=4)

#This gives the multiplier for 95\%-confidence intervals based on the z-statistic
qnormGC(0.95,region="between")

#This gives critical values for a two-sided z-test with alpha = 0.01:
qnormGC(0.01,region="outside")
}
\author{
Homer White \email{hwhite0@georgetowncollege.edu}
}

