% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{insertFigures}
\alias{insertFigures}
\title{Insert figures}
\usage{
insertFigures(db, experimentName, regulatorName, filename, name = "",
  description = "", priority = 0)
}
\arguments{
\item{db}{Database object created by \code{\link{initializeDb}}}

\item{experimentName}{Experiment name}

\item{regulatorName}{Regulator name (more detailed experiment identifier)}

\item{filename}{URL path to figures. The path can contain the
special form \code{${probe_name}} which will be substituted
by the name of the entity (gene, ...) by the browser.}

\item{name}{Optional figure name}

\item{description}{Optional figure description}

\item{priority}{Integer priority used for sorting figures (default: 0)}
}
\value{
An updated database object db
}
\description{
Insert figures
}
\examples{
  db <- initializeDb("", "My Dataset")
  logl <- c(-4.0, -2.0, 0.0)
  names(logl) <- c("A", "B", "C")
  baselogl <- c(1.0, -1.0, 4.0)
  names(baselogl) <- names(logl)
  db <- insertResults(db, "testexperiment", "testregulator", "",
                     logl, baselineloglikelihoods=baselogl)
  db <- insertFigures(db, "testexperiment", "testregulator",
                      "http://foo.invalid/path/${probe_name}_fit.png")
  closeDb(db)
}

