% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enumeration_units.R
\name{school_districts}
\alias{school_districts}
\title{Download a school district shapefile into R}
\usage{
school_districts(state = NULL, type = "unified", cb = FALSE, year = NULL, ...)
}
\arguments{
\item{state}{The two-digit FIPS code (string) of the state you want. Can also
be state name or state abbreviation. When \code{NULL} and combined with
\code{cb = TRUE}, a national dataset of school districts will be returned for
years 2019 and later.}

\item{type}{Specify whether you want to return a unified school district (the default, \code{'unified'}),
an elementary school district (\code{'elementary'}), or a secondary school district (\code{'secondary'}).
Please note: elementary and secondary school districts do not exist in all states}

\item{cb}{if TRUE, download a generalized (1:500k)
school districts file.  Defaults to FALSE (the most detailed TIGER/Line file)}

\item{year}{the data year; defaults to 2020}

\item{...}{arguments to be passed to the underlying `load_tiger` function, which is not exported.
Options include \code{class}, which can be set to \code{"sf"} (the default) or \code{"sp"} to
request sf or sp class objects, and \code{refresh}, which specifies whether or
not to re-download shapefiles (defaults to \code{FALSE}).}
}
\description{
From the US Census Bureau (see link for source):
School Districts are single-purpose administrative units within which local officials provide public
educational services for the area's residents. The Census Bureau obtains school district boundaries,
names, local education agency codes, grade ranges, and school district levels biennially from state
education officials. The Census Bureau collects this information for the primary purpose of providing the
U.S. Department of Education with annual estimates of the number of children in poverty within each
school district, county, and state. This information serves as the basis for the Department of Education to
determine the annual allocation of Title I funding to states and school districts.
}
\details{
The Census Bureau creates pseudo-unified school districts for areas in which unified school districts do
not exist.  Additionally, elementary and secondary school districts do not exist in all states.
Please see the link for more information on how the Census Bureau creates the school district shapefiles.
}
\examples{
\dontrun{
library(tigris)
library(leaflet)

schools <- school_districts("Maine")

leaflet(schools) \%>\%
  addProviderTiles("CartoDB.Positron") \%>\%
  addPolygons(fillColor = "white",
              color = "black",
              weight = 0.5)
}
}
\seealso{
\url{https://www2.census.gov/geo/pdfs/maps-data/data/tiger/tgrshp2020/TGRSHP2020_TechDoc.pdf}

Other general area functions: 
\code{\link{block_groups}()},
\code{\link{blocks}()},
\code{\link{counties}()},
\code{\link{county_subdivisions}()},
\code{\link{places}()},
\code{\link{pumas}()},
\code{\link{states}()},
\code{\link{tracts}()},
\code{\link{zctas}()}
}
\concept{general area functions}
