% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enumeration_units.R
\name{zctas}
\alias{zctas}
\title{Download a Zip Code Tabulation Area (ZCTA) shapefile into R}
\usage{
zctas(cb = FALSE, starts_with = NULL, year = NULL, state = NULL, ...)
}
\arguments{
\item{cb}{If cb is set to TRUE, download a generalized (1:500k)
ZCTA file.  Defaults to FALSE (the most detailed TIGER/Line file).
\strong{A warning:} the detailed TIGER/Line ZCTA file is massive
(around 502MB unzipped), and the generalized version is also large
(64MB zipped).  Be prepared for this especially if you have a slower
internet connection.}

\item{starts_with}{Character vector specifying the beginning digits of the
ZCTAs you want to return.  For example, supplying the argument
\code{starts_with = c("75", "76")} will return only those ZCTAs that begin
with 75 or 76.  Defaults to NULL, which will return all ZCTAs in the US.}

\item{year}{the data year (defaults to 2020).}

\item{state}{the state for which you are requesting data; only available for 2000 (TIGER/Line
and CB shapefiles) and 2010 (TIGER/Line shapefiles only)}

\item{...}{arguments to be passed to the underlying `load_tiger` function, which is not exported.
Options include \code{class}, which can be set to \code{"sf"} (the default) or \code{"sp"} to
request sf or sp class objects, and \code{refresh}, which specifies whether or
not to re-download shapefiles (defaults to \code{FALSE}).}
}
\description{
ZIP Code Tabulation Areas (ZCTAs) are generalized areal representations of
United States Postal Service (USPS) ZIP Code service areas.  Please see the link provided for
information on how the Census Bureau creates ZCTAs, and for important information on the
differences between ZCTAs and ZIP Codes.
}
\examples{
\dontrun{
# Example: get ZCTAs that intersect the Memphis, TN urbanized area

library(tigris)
zcta1 <- zctas(cb = TRUE, starts_with = c("37", "38", "72"))

uas <- urban_areas()

memphis_ua <- uas[grep("Memphis", uas$NAME10), ]

mem_zcta <- zcta1[memphis_ua, ]

plot(mem_zcta$geometry)

}
}
\seealso{
\url{https://www.census.gov/programs-surveys/geography/guidance/geo-areas/zctas.html}

Other general area functions: 
\code{\link{block_groups}()},
\code{\link{blocks}()},
\code{\link{counties}()},
\code{\link{county_subdivisions}()},
\code{\link{places}()},
\code{\link{pumas}()},
\code{\link{school_districts}()},
\code{\link{states}()},
\code{\link{tracts}()}
}
\concept{general area functions}
